#extension GL_EXT_draw_buffers : enable

precision mediump float;

#define HIGHLIGHT_BOTTOM_COLOUR       vec3(0.5,0.7,0.7)
#define HIGHLIGHT_TOP_COLOUR          vec3(0.4,0.5,0.8)
#define HIGHLIGHT_COLOR_MIX           0.3
#define HIGHLIGHT_LUMINANCE_POWER     0.5

uniform sampler2D 	texture_diffuse;
uniform sampler2D 	texture_emissive;
uniform vec4  		colour_emissive;

varying vec4 		v_colour;
varying vec3 		v_normal;
varying vec2 		v_uv;


void main()
{
    // Fetch Fragments Normal + Diffuse textures    
    vec4 diffuse  = texture2D( texture_diffuse, v_uv) * v_colour;
    vec4 emissive = texture2D( texture_emissive, v_uv);
   
    // Apply Bi-directional lighting
    float nl_bottom = dot(v_normal.xyz,vec3(0.0,1.0 ,0.0));
    float nl_top    = dot(v_normal.xyz,vec3(-0.577, -0.577, -0.577));
    vec3  attr      = (HIGHLIGHT_BOTTOM_COLOUR * clamp(nl_bottom,0.0,1.0)) + (HIGHLIGHT_TOP_COLOUR * clamp(nl_top,0.0,1.0));
    diffuse.xyz     = mix(diffuse.xyz,attr,HIGHLIGHT_COLOR_MIX);
    float lum       = dot(attr,vec3(0.30, 0.59, 0.11))*HIGHLIGHT_LUMINANCE_POWER;
   
    // Pick whether to use the emissive colour or the diffuse
    // colour_emissive.w = 1.0h  ... use colour_emissive
    // colour_emissive_w = 0.0h  ... use diffuse
    vec4 diffuseCol  = (diffuse*(1.0-colour_emissive.w)) + (colour_emissive*colour_emissive.w);
    diffuseCol = mix(diffuse,diffuseCol,emissive.r);
        
    // Pack vertex normal
    //vec4 normal = vec4((v_normal.xyz+1.0)*0.5,emissive.r+lum);
    
    // Write to albedo+normal buffers    
    gl_FragColor = diffuseCol;
}
